function lyngby_log(String) 

% lyngby_log           - Log
%
%	function lyngby_log(String)
%
%	Input:	String		String to be logged
%
%	Global:	UIHANDLE_LOG	Uicontrol that displays the string
%               LOGFILENAME     Log filename
%
%       lyngby_log writes a string either in a uicontrol, to a file
%       or with the 'disp' command. If UIHANDLE_LOG is defined it will
%       be used as the uicontrol. If it is not defined and LOGFILENAME
%       is defined the string will be written to the file, else the
%       string will be display with matlab's 'disp' command.
%       If LOGFILENAME is defined but not a string nothing will be
%       written.
%
%       Example:
%         lyngby_log('lyngby_log.m called')
%
%       See also: LYNGBY, LYNGBY_UI_MAIN, LYNGBY_UI_MESSAGE.
%
% $Id: lyngby_log.m,v 1.4 2002/11/20 10:40:56 fnielsen Exp $


    global UIHANDLE_LOG LOGFILENAME

    if ~isempty(UIHANDLE_LOG)
      set(UIHANDLE_LOG, 'String',  ['  ' String]);
      drawnow
    else
      if ~isempty(LOGFILENAME)
	if isstr(LOGFILENAME)
	  lfid = fopen(LOGFILENAME,'at');
	  fwrite(lfid,String);
	  fclose(lfid);
	else
	  % Nothing: Swallow string
	end
      else
	disp(String);
      end
    end

















