function Lambda = lyngby_lz_lambda(Theta1, Theta2, Time, forceOne);
 
% lyngby_lz_lambda	- The Lange-Zeger hemodynamic response function
%
%       function Lambda = lyngby_lz_lambda(Theta1, Theta2, Time, ForceOne);
%
%       Input:  Theta1    A row vector with theta1 parameters
%               Theta2	  A row vector with theta2 parameters
%               Time      A column vector with sampletime
%               forceOne  If 'ForceOne' is nonzero then force
%                         distribution to one. 
%	
%       Output: Lambda	  Evalution of the function
%
%       This function is the same as the gamma distribution function. 
%       The theta1 is the shape parameter; theta2 is the scale
%       parameter. The theta1/theta2 ratio is the center of mass for
%       the kernel. Theta1 should be larger than 1 to yield an
%       increasing curve in the beginning.
% 
%       See also LYNGBY, LYNGBY_LZGS_MAIN, LYNGBY_LZGS_SEARCH,
%                LYNGBY_LZIT_MAIN, LYNGBY_LZ_ERROR,
%                LYNGBY_LZ_MASSCENT.  
%
% $Id: lyngby_lz_lambda.m,v 1.2 2003/04/28 15:11:09 fnielsen Exp $

    force = 0;

    if exist('forceOne')
      if strcmp(lower(forceOne), 'forceone')
	force = 1;
      end
    end
    
    Lambda = (ones(length(Time),1) * (Theta2.^(Theta1) ./ gamma(Theta1) )) .* ...
	( (Time * ones(1, length(Theta1))).^(ones(length(Time),1)*(Theta1-1)) ) .* ...
	exp(-Time*Theta2);
    
    
    if force
      l = length(Time);
      if  l > 1
	d = Time(2) - Time(1);
	Lambda(1,:) = 1/d - sum(Lambda(2:l,:));
      end
    end



















