function M = lyngby_lz_masscent(result_lz);

% lyngby_lz_masscenter - Returns the masscenter of the Lange Zeger Kernel 
%
%       function M = lyngby_lz_masscent(result_lz);
%
%       Input:  result_lz  Result from the Lange Zeger analysis 
%
%       Output: M          Mass center
%
%       The mass center of the Lange Zeger kernel is just
%       Theta1 divided by theta2.
%
%       See also LYNGBY, LYNGBY_LZGS_MAIN, LYNGBY_LZIT_MAIN.
%
% $Id: lyngby_lz_masscent.m,v 1.3 2003/04/28 15:06:35 fnielsen Exp $

	M = result_lz(2,:) ./ (realmin + result_lz(3,:));









