function lyngby_lz_plot(hand, paradigm, datavec, parameters)

% lyngby_lz_plot		- Plot Paradigm, data and Lange-Zeger model
%
%       function lyngby_lz_plot(hand, paradigm, datavec, parameters)
%
%	Input:	hand		Grafic handle
%		paradigm	The paradigm
%		datavec		The data
%		parameters	The Lange-Zeger parameter: [beta; theta1; theta2;]

%	Date		Author		Version
%	1996-09-18	Peter Toft	Initial Version
%	1996-09-19	Peter Toft	Now uses lyngby_lz_lambda
%	1996-11-04	fnielsen	Split: lyngby_plotmatch, lyngby_lz_plot
%	1996-11-06	fnielsen	Last 3 arguments joined to one: parameters
%	1996-01-30	fnielsen	Added ForceOne

% cvs :  $Revision: 1.1.1.1 $

	% paradigm=(paradigm-mean(paradigm))/std(paradigm);
	% datavec=(datavec-mean(datavec))/std(datavec);

	time = 0:length(paradigm)-1;
	resp = lyngby_lz_lambda(parameters(2,:),parameters(3,:),time', 'ForceOne');
	resp = resp * parameters(1,:);

 	lyngby_plotmatch(hand, paradigm, datavec, resp); 







