function lyngby_lz_plottheta(fig, arg);

% lyngby_lz_plottheta	- Plot Lange-Zeger theta1 against theta2 
%
%	function lyngby_lz_plottheta(fig, arg);
%
%	Input:	fig	Figure number
%		arg	'clear':Clears internal representation
%				of previous thetas
%			2x1 element vector: Adds a new entry to 
%				an accumulation of thetas
%			2xN element matrix: Plot the matrix as
%				an accumulation of thetas.
%
%	Plotting the Lange-Zeger model theta parameters.
%	First element should be theta1.

%	Date		Author		Version
%	1996-09-16	fnielsen	Initial Version

% cvs :  $Revision: 1.1.1.1 $

	
	global THETA_ACC

	if isstr(arg)
		figure(fig), clf;
		clear global THETA_ACC;
		return
	end

	size_arg = size(arg);
	if size_arg(2) == 1
		THETA_ACC = [THETA_ACC arg];
	else
		THETA_ACC = arg;		
	end

	plot(THETA_ACC(1,:),THETA_ACC(2,:),'o',THETA_ACC(1,:),THETA_ACC(2,:),'-')
	
	title('Development of the theta parameters');
	xlabel('Theta 1');
	ylabel('Theta 2');
	drawnow;

