function Theta = lyngby_lzgs_main(P, X,...
    arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, ...
    arg11, arg12, arg13, arg14, arg15, arg16)
    
% lyngby_lzgs_main     - Lange-Zeger model with grid search
%
%       function Theta = lyngby_lzgs_main(P, X,...
%          'PropertyName', 'PropertyValue')
%
%       Input:    P          The paradigm
%                 X          The datamatrix 
%         
%       Property: MinTheta1  Min minimum value of theta1 
%                 MaxTheta1  Min maximum value of theta1 
%                 NumTheta1  Number of theta1 value in the search
%                 MinSlope   Min minimum value of slope in the search
%                 MaxSlope   Min maximum value of slope in the search
%                 NumSlope   Number of theta1 slope in the search
%                 Reg        Regularization weight on the value of the
%                            excitation Beta
%                 Zoom       How many times should the search be
%                            refined using a small search window
%                            around the optimal point using the same
%                            number of samples again.
%
%       Output: Theta        The result from the Lange-Zeger model
%                            with the order [ Beta : Theta1 ; Theta2 ]
%
%       Main function for Lange Zeger model using penalized grid
%       search of parameters: The search is made in theta1 and slope,
%       where slope = (theta1-1)/theta2
%
%       See also LYNGBY, LYNGBY_LZGS_SEARCH, LYNGBY_LZIT_MAIN.
%
% $Id: lyngby_lzgs_main.m,v 1.4 2003/04/28 15:22:19 fnielsen Exp $



    % Size
    [rX, cX] = size(X);
    
    % Default properties
    minTheta1 = 1.5;
    maxTheta1 = 15;
    numTheta1 = 10;
    minSlope  = 0.5;
    maxSlope  = 5;
    numSlope  = 10;
    reg       = 1;
    zoom      = 0;
    
    
    % Parse properties
    n = 1;
    while n < nargin-1
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'mintheta1')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	minTheta1 = arg;
	if minTheta1 < 0 
	  error('''MinTheta1'' should be a larger than 0.')
	end
      elseif strcmp(arg, 'maxtheta1')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	maxTheta1 = arg;
	if maxTheta1 < 0 
	  error('''MaxTheta1'' should be a larger than 0.')
	end
      elseif strcmp(arg, 'numtheta1')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	numTheta1 = arg;
	if numTheta1 < 1 
	  error('The ''NumTheta1'' be a value larger than 1.')
	end
      elseif strcmp(arg, 'minslope')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	minSlope = arg;
	if minSlope < 0 
	  error('''MinSlope'' should be a larger than 0.')
	end
      elseif strcmp(arg, 'maxslope')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	maxSlope = arg;
	if maxSlope < 0 
	  error('''MaxSlope'' should be a larger than 0.')
	end
      elseif strcmp(arg, 'numslope')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	numSlope = arg;
	if numSlope < 1 
	  error('The ''NumSlope'' be a value larger than 1.')
	end
      elseif strcmp(arg, 'reg')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	reg = arg;
	if reg <= 0
	  error('''Reg'' should be a value <= 0.')
	end
      elseif strcmp(arg, 'zoom')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	zoom = arg;
	if zoom < 0
	  error('The step size should be a value larger than 1.')
	end
      else
	error(sprintf('Invalid property %s (lyngby_lzgs_main)',arg));
      end
      n = n + 1;
    end
    

    T = (0:1:20)';

    Opttheta1 = zeros(1, cX);
    Opttheta2 = zeros(1, cX);
    Optbeta   = zeros(1, cX);

    for ii = 1:cX

      x = X(:,ii);
      
      lyngby_log(sprintf('Computing grid search LZ-map: %3.0f%%', ...
	  100*ii/cX));
      [theta1, slope, beta] = lyngby_lzgs_search(P, x, T,...
	  minTheta1, maxTheta1, numTheta1,...
	  minSlope, maxSlope, numSlope,...
	  reg, zoom);
      
      Opttheta1(ii) = theta1;
      Opttheta2(ii) = (theta1-1)/slope;
      Optbeta(ii)   = beta;
    end

    Theta = [Optbeta ; Opttheta1 ; Opttheta2];


















