function Beta = lyngby_lzit_beta(Y, X, Noise);

% lyngby_lzit_beta     - Lange-Zeger, Estimate beta parameter
%
%	function Beta =  lyngby_lzit_beta(Y, X, Noise);
%
%	Input:	Y	The fourier transformed response matrix 
%		X	The fourier transformed convolution matrix
%		Noise	The fourier transformed noise matrix
%	
%	Output:	Beta	A row vector with etimate for the Beta parameter
%
%	The Beta parameter is the 'amplitude' parameter.
%
%       See also: lyngby_lzit_main

% cvs : $Id: lyngby_lzit_beta.m,v 1.2 1997/10/28 10:29:09 fnielsen Exp $
%       $Revision: 1.2 $

    Beta = sum((conj(Y).*X)./ Noise) ./ ...
	sum((conj(X).*X) ./ Noise);

    if 1==1
      Beta = real(Beta);
    end




