function Y = lyngby_lzit_conv(FP, Param)

% lyngby_lzit_conv     - Lange-Zeger, Convolve kernel with the input
%
%	function Y = lyngby_lzit_conv(FP, Parameters)
%
%	Input:	FP	The fourier transformed paradigm
%		Param	Gamma kernel parameters
%
%	Output:	Y	Convole output (time domain)
%
%	See also: lyngby_lzit_ftlamb

% cvs : $Id: lyngby_lzit_conv.m,v 1.2 1997/10/28 10:26:41 fnielsen Exp $
%       $Revision: 1.2 $

    T = length(FP);

    Y = real(ifft( (FP * Param(1,:)) .* lyngby_lzit_ftlamb(Param(2,:), Param(3,:), [0:T/2-1 -T/2:-1]'/T)));

    % 180 phase shift !?
    % FP = fftshift(FP);
    % Y = real(ifft( fftshift((FP * Param(1,:)) .* lyngby_lzit_ftlamb(Param(2,:), Param(3,:), [-T/2:T/2-1]'/T))));

