function Q = lyngby_lzit_cost(X,Y, Noise, theta1, theta2, beta, T, n);

% lyngby_lzit_cost     - The cost function used in the Lange-Zeger model
%
%	function Q = lyngby_lzit_cost(X,Y, theta1, theta2, beta, T, n);
%
%	Input:	X	The fourier transformed paradigm
%		Y	The fourier transformed data
%	
%	Output:	Q	The costfunction evaluated

% cvs : $Id: lyngby_lzit_cost.m,v 1.2 1997/10/28 10:25:10 fnielsen Exp $
%       $Revision: 1.2 $

    Lambda = lyngby_lzit_ftlamb(T,n,theta1,theta2);

    X = Lambda .* lyngby_lzit_pickf(X,n);
    Y = lyngby_lzit_pickf(Y,n);

    Diff = abs(Y - X*beta*ones(1,size(Y,2)));
    Q = sum( Diff.^2 ./ (Noise*ones(1,size(Y,2)))); 
	





