function ftLambda = lyngby_lzit_ftlamb(arg1, arg2, arg3, arg4);

% lyngby_lzit_ftlamb   - Lange-Zeger, Fourier transformed of lambda
%
%	function ftLambda = lyngby_lzit_ftlamb(T,n,theta1,theta2);
%	function ftLambda = lyngby_lzit_ftlamb(Theta1,Theta2, Freq);
%
%	Input:	T		Number of scans
%		n		Paradigm periodes
%		theta1,theta2	Lambda function parameters
%		Theta1,Theta2	Lambda function parameters (row vectors)
%		Freq		Frequency components (column vector)
%	
%	Output:	ftLambda	The fourier transformed of the lambda function
%
%	Lambda is the kernel function.
%	Using a different sign than the expression in the article does.
%	(1+jw/theta1)^(-theta2) is with F(w) = sum( f(t)e^(-jwt) )
%	This is also the matlab standard with the fft function.

% cvs : $Id: lyngby_lzit_ftlamb.m,v 1.2 1997/10/28 10:27:53 fnielsen Exp $ 
%       $Revision: 1.2 $

    if nargin == 4
      T = arg1;
      n = arg2;
      theta1 = arg3;
      theta2 = arg4;
      
      m = [1:(T/(2*n))]';
      ftLambda = (1+(2*pi*n*m/T)*j/(realmin+theta2)).^(-theta1);
    elseif nargin == 3
      Theta1 = arg1;
      Theta2 = arg2;
      Freq = arg3;
      
      voxels = size(Theta1,2);
      components = size(Freq,1);
      
      ftLambda = ( 1 + (((2*pi*j*Freq)*ones(1,voxels)) ./ (ones(components,1)*(realmin+Theta2)))) .^ ...
	  (-ones(components,1)*Theta1);
    
    end













