function Y = lyngby_lzit_pickf(X,arg);

% lyngby_lzit_pickf	- Pick frequencies out from the data matrix
%
%	function Y = lyngby_lzit_pickf(X,n);
%	function Y = lyngby_lzit_pickf(X,FP);
%
%	Input:	X	A matrix
%		n	Number of periodes of the paradigm (scalar)
%		FP	The fourier transformed paradigm (vector)
%	
%	Output:	Y	The output matrix
%
%	If the paradigm have fourier components that are zero
%	at certain frequencies these might be discarded. 
%	<n> can only be used if the paradigmfrequency is a even number 
%	of the run/session.
%	Using <FP> the frequency components with amplitude smaller than
%	1000 x eps will be discarded. 

% cvs : $Id: lyngby_lzit_pickf.m,v 1.2 1997/10/28 10:24:28 fnielsen Exp $
%       $Revision: 1.2 $

    if length(arg) == 1
      n = arg;
      
      T = size(X,1);
      N = floor(T/2)/n;
      Y = X((1:N)*n+1,:);
    else
      FP = arg;
      [row, col] = find(abs(FP).*(abs(FP)>eps*10^3));
      Y = X(row, :);
    end












