function indexInFull = lyngby_mask2full(indexInMask);

% lyngby_mask2full     - Convert indices from ROI to Full volume
%
%	function indexInFull = lyngby_mask2full(indexInMask);
%
%       Input:  indexInMask   Scalar index in ROI volume
%
%       Output: indexInFull   3 Element index in Full Volume
%
%       See also: lyngby_full2mask, lyngby_index2vmask,
%                 lyngby_vmask2lyngby

% cvs : $Id: lyngby_mask2full.m,v 1.2 1998/03/27 17:39:20 fnielsen Exp $
%       $Revision: 1.2 $

    lyngby_global

    if issparse(VOXEL_MASK)
      indexInMask = find(VOXEL_MASK(:,indexInMask));
    end
    
    roi = lyngby_roi;
    dim = roi(:,2) - roi(:,1) + 1;
    offset = roi(:,1) - 1;
    
    z = fix((indexInMask-1) ./ prod(dim(1:2)))+1;
    y = fix( (indexInMask-1 - (z-1)*prod(dim(1:2))) ./ dim(1)) + 1;
    x = rem(indexInMask-1, dim(1)) + 1;
    
    indexInFull = [x y z] + offset';
    

	




