function my = lyngby_meangeo(X);

% lyngby_meangeo       - Geometric mean
%
%	function my = lyngby_meangeo(X);
%
%	Input:  X   The data
%
%       Output: my  The geometric mean
%
%       See also: lyngby_meanhl

% cvs : $Id: lyngby_meangeo.m,v 1.2 1998/03/17 17:46:42 fnielsen Exp $ 
%       $Revision: 1.2 $

    [rX, cX] = size(X);
    if rX == 1
      n = cX;
    else
      n = rX;
    end
    
    if min(min(X)) <= 0
      error('Elements of X should be larger than 0');
    end
    
    my = prod(X).^(1/n);












