function my = lyngby_meanhl(X);

% lyngby_meanhl        - Hodges-Lehmann estimator
%
%	function my = lyngby_meanhl(X);
%
%	Input:  X   The data
%
%       Output: my  The Hodge-Lehmann estimator
%
%	The Hodges-Lehmann estimator is the median of all 
%	pairwise averages. It is suppose to be both a robust and
%	efficient estimation of the mean.

% cvs : $Id: lyngby_meanhl.m,v 1.1 1997/09/29 11:49:40 fnielsen Exp $ 
%       $Revision: 1.1 $

    [Nr,Nc] = size(X);

    if Nr==1
      X = X';
      Nr = Nc;
      Nc = 1;
    end
    
    my = zeros(1,Nc);
    for c = 1:Nc
      Xr = X(:,c) * ones(1,Nr);
      Xc = ones(Nr,1) * X(:,c)';
      
      my(c) = median(reshape(Xr + Xc,1,Nr*Nr)) / 2;
    end












