function [U,S,V,mean_pic] = lyngby_msvd_main(DATA, arg1, arg2, arg3, ...
    arg4,arg5,arg6, arg7, arg8, arg9, arg10, arg11, arg12)

% lyngby_msvd_main  - Perform meta svd comparison of selected models.
%
%   function [Y] = lyngby_msvd_main(DATA,'PropertyName',PropertyValue)
%
%   DATA contains the ''picture'' from each model in the rows. 
%
%  PropertyNames   PropertyValue
%   'Strength'     0 or 1 comparison of strength. 
%   'Delay'        0 or 1 comparison of delay.
%   'Histeq'       0 or 1 Using histogram equalization.
%   'Bins'         {256} Number of bins used in the histogram equal.
%   'Reference'    [] or datavector (row) from a model Which model 
%   used for histogram equalization  no models means a uniform 
%   equalization.
%   'Trunc'        0 or 1 using abs for making positive values. 
%
%   [U,S,V] = svd(DATA',0); (economy size)
%
%   U contains the eigenpictures. 
%   S contains the eigenvalues.   
%   V contains the projections.
%   
%   mean_pic is the mean delay or mean strength for the selected models.
%
%   if DATA = []
%   Choose a reference (number) press enter
%   Then choose the models for comparison like this ['1','2','3','4']
%
%   Default values:
%   strength = 0;
%   delay = 0;
%   histeq = 0;
%   bins = 256;
%   reference = [];
%   trunc = 0;

% Default values
    strength = 0;
    delay = 0;
    histeq = 0;
    bins = 256;
    reference = [];
    trunc = 0;
    
    n=1;
    while n < nargin-1
      eval(sprintf('arg = lower(arg%d);',n));
      if strcmp(arg, 'strength')
	n = n+1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''Strength'' should be a ' ...
		'value. Is a string: ''%s'''], arg));
	elseif length(arg) ~= 1 
	  error(sprintf(['Property value to ''Strength'' should be a ' ...
		'scalar. Length: %d'], length(arg)));
	elseif ~(arg ~= 0 | arg ~= 1)
	  error(sprintf(['Property value to ''Strength'' should be ' ...
		'either 0 or 1. It is: %f'], arg));
        else
	  strength = arg;	
	end
	
      elseif strcmp(arg, 'delay')
      	n = n+1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''Delay'' should be a ' ...
		'value. Is a string: ''%s'''], arg));
	elseif length(arg) ~= 1 
	  error(sprintf(['Property value to ''Delay'' should be a ' ...
		'scalar. Length: %d'], length(arg)));
	elseif ~(arg ~= 0 | arg ~= 1)
	  error(sprintf(['Property value to ''Delay'' should be ' ...
		'either 0 or 1. It is: %f'], arg));
        else
	  delay = arg;
        end
      
      elseif strcmp(arg, 'histeq')
      	n = n+1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''Histeq'' should be a ' ...
		'value. Is a string: ''%s'''], arg));
	elseif length(arg) ~= 1 
	  error(sprintf(['Property value to ''Histeq'' should be a ' ...
		'scalar. Length: %d'], length(arg)));
	elseif ~(arg ~= 0 | arg ~= 1)
	  error(sprintf(['Property value to ''Histeq'' should be ' ...
		'either 0 or 1. It is: %f'], arg));
        else
          histeq = arg;
        end
      
      elseif strcmp(arg, 'bins')
      	n = n+1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''Bins'' should be a ' ...
		'value. Is a string: ''%s'''], arg));
	elseif length(arg) ~= 1 
	  error(sprintf(['Property value to ''Bins'' should be a ' ...
		'scalar, integer. Length: %d'], length(arg)));
	elseif (arg <= 0 | rem(arg,1) ~= 0)
	  error(sprintf(['Property value to ''Bins'' should be ' ...
		'larger than zero and a integer. It is: %f'], arg));
        else
          bins = arg;
        end
      
      elseif strcmp(arg, 'reference')
      	n = n+1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	error(sprintf(['Property value to ''Reference'' should be a ' ...
		'value. Is a string: ''%s'''], arg));
	else
	  reference = arg;
	end
	
      
      elseif strcmp(arg, 'trunc')
      	n = n+1;
	eval(sprintf('arg = arg%d;', n));
	if isstr(arg) 
	  error(sprintf(['Property value to ''Trunc'' should be a ' ...
		'value. Is a string: ''%s'''], arg));
	elseif length(arg) ~= 1 
	  error(sprintf(['Property value to ''Trunc'' should be a ' ...
		'scalar. Length: %d'], length(arg)));
	elseif ~(arg ~= 0 | arg ~= 1)
	  error(sprintf(['Property value to ''Trunc'' should be ' ...
		'either 0 or 1. It is: %f'], arg));
        else
          trunc = arg;
        end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n+1;
    end

    if strength == 1 & delay == 1
      error(sprintf('Both strength and delay are selected for comparison'));
    elseif strength == 0 & delay == 0
      error(sprintf('Nor strength og delay are selected for comparison'));
    end
    
    
    if isempty(DATA)
      lyngby_ui_global;
      Possible_models= [];
      ResInfo = lyngby_ui_resinfo;
      if strength == 1
	
	Matchnr = [strmatch('STRENGTH',ResInfo)];
        Com_Models = ResInfo(Matchnr,:);
	[Nr_options dummy] = size(Com_Models);

	for modelnr = 1:Nr_options
          if isempty(eval(Com_Models(modelnr,:))) == 0
             Possible_models = [Possible_models;Com_Models(modelnr,:)];
          end % if isempty(eval(Com_Models(modelnr,:))) == 0
        end % for modelnr = 1:Nr_options

	[Nr_options dummy] = size(Possible_models);
        Model_nr = [];
	Kolon = [];
	for i = 1:Nr_options
	  Model_nr = [Model_nr;i];
	  Kolon = [Kolon; ' : '];
	end % for i = 1:Nr_options
        Model_nr = [num2str(Model_nr),Kolon];
	MODELS = [Model_nr,Possible_models];
        display(MODELS)
        reference = input('Select a reference : ');
	selected_models = input('Select models for comparison : ')';
        [num_sel dummy] = size(selected_models);
        sel_mod = str2num(selected_models);
	[dummy no_voxel] = size(X);
	DATA = zeros(num_sel,no_voxel);

	for i=1:num_sel
	  dummy = Possible_models(sel_mod(i),:);
	  DATA(i,:) = eval(dummy);
	end % for i=1:num_sel
	
	if reference == 0
	  else
	  dummy = Possible_models(reference,:);
	  reference = eval(dummy);
        end % refence == 0

	if trunc == 1
          DATA = abs(DATA);
	  reference = abs(reference);
	
	  if histeq == 1
	    Y = lyngby_histeq(DATA','Bins',bins,'Reference',reference');
	    [U,S,V] = svd(Y,0);
	    mean_pic = mean(Y');
	  else % if histeq == 1
	    [U,S,V] = svd(DATA',0);
	    mean_pic = mean(DATA);
	  end % histeq == 1    
	else % if trunc == 1
	
	  if histeq == 1
    	    Y = lyngby_histeq(DATA','Bins',bins,'Reference',reference');
	    [U,S,V] = svd(Y,0);
	    mean_pic = mean(Y');
	  else
	    [U,S,V] = svd(DATA',0);
	    mean_pic = mean(DATA);
          end % if histeq == 1    
        end % if trunc == 1
      else % if strength == 1
	Matchnr = [strmatch('DELAY',ResInfo)];
        Com_Models = ResInfo(Matchnr,:);
        [Nr_options dummy] = size(Com_Models);

	for modelnr = 1:Nr_options
          if isempty(eval(Com_Models(modelnr,:))) == 0
             Possible_models = [Possible_models;Com_Models(modelnr,:)];
          end % if isempty(eval(Com_Models(modelnr,:))) == 0
	end % for modelnr = 1:Nr_options
	
        [Nr_options dummy] = size(Possible_models);
        Model_nr = [];
	for i = 1:Nr_options
	  Model_nr = [Model_nr; num2str(i) ' : '];
	end % for i = 1:Nr_options
	
	MODELS = [Model_nr,Possible_models];
        display(MODELS)
        reference = input('Select a reference : ');
	selected_models = input('Select models for comparison : ')';
        [num_sel dummy] = size(selected_models);
        sel_mod = str2num(selected_models);
	[dummy no_voxel] = size(X);
	DATA = zeros(num_sel,no_voxel);
	
	for i=1:num_sel
	  dummy = Possible_models(sel_mod(i),:);
	  DATA(i,:) = eval(dummy);
	end % for i=1:num_sel
	
	if reference == 0
	  else
	  dummy = Possible_models(reference,:);
	  reference = eval(dummy);
        end % refence == 0

	
	if trunc == 1
          DATA = abs(DATA);
	  reference = abs(reference);
	  if histeq == 1
	    Y = lyngby_histeq(DATA','Bins',bins,'Reference',reference');
	    [U,S,V] = svd(Y,0);
	    mean_pic = mean(Y');
	  else
	    [U,S,V] = svd(DATA',0);
	    mean_pic = mean(DATA);
	  end % histeq == 1   
        else % trunc == 1
	  if histeq == 1
    	    Y = lyngby_histeq(DATA','Bins',bins,'Reference',reference');
	    [U,S,V] = svd(Y,0);
	    mean_pic = mean(Y');
	  else
	    [U,S,V] = svd(DATA',0);
	    mean_pic = mean(DATA);
          end % histeq == 1       
        end % trunc == 1	
      end % if strength == 1
    else % if isempty(DATA)
      if trunc == 1
        DATA = abs(DATA);
	reference = abs(reference);
	if histeq == 1
	  Y = lyngby_histeq(DATA','Bins',bins,'Reference',reference');
	  [U,S,V] = svd(Y,0);
	  mean_pic = mean(Y');
	else
	  [U,S,V] = svd(DATA',0);
	  mean_pic = mean(DATA);
	end % if histeq == 1     
      else % trunc == 1	
	if histeq == 1
	  Y = lyngby_histeq(DATA','Bins',bins,'Reference',reference');
	  [U,S,V]=svd(Y,0);
	  mean_pic = mean(Y');
	else
	  [U,S,V] = svd(DATA',0);
	  mean_pic = mean(DATA);
	end % if histeq == 1     
      end % trunc == 1	
    end % if isempty(DATA)

