function [C, dCU] = lyngby_nn_ccdc(Uv, X, T, Reg, N)

% lyngby_nn_ccdc       - NN-classifier cost function and derivative
%
%       function [C, dC] = lyngby_nn_ccdc(Uv, X, T, Reg);
%
%       See also LYNGBY, LYNGBY_NN_CMAIN, LYNGBY_NN_U2VW.

% cvs : $Id: lyngby_nn_ccdc.m,v 1.1 2000/10/23 14:41:33 fnielsen Exp $
%       $Revision: 1.1 $

    Nii = N(1,1);
    Nhh = N(1,2);
    Ni  = N(2,1);
    Nh  = N(2,2);
    No  = N(2,3);
    Nv  = Nii * Nh;
    Nw  = Nhh * No;
    Np  = size(X,1);
    
    HB = ones(Np, 1);
    
    [V, W] = lyngby_nn_u2vw(Uv, N);

    % The cost function
    [Y,O,H] = lyngby_nn_cforward(X, V, W);
    E       = lyngby_nn_cerror(T, Y, O);
    C	    = lyngby_nn_cost(E, V, W, Reg);
    EY      = Y - T;
    
    % First order derivative of Regularization 
    dRUv  = lyngby_nn_cdru(V, W, Reg);      
    dRV   = reshape(dRUv(1:Nv), Nii, Nh);
    dRW   = reshape(dRUv(Nv+(1:Nw)), Nhh, No);
    
    % Output weights, First order derivative
    dEW       = lyngby_nn_cdew(EY, [H HB], W);
    dCW       = dEW + dRW;
    
    % Hidden weights, First order derivative
    [dEV,H12] = lyngby_nn_cdev(EY, H, X, V, W);
    dCV       = dEV + dRV;

    dCU = [ dCV(:) ; dCW(:) ];









