function ddEW = lyngby_nn_cddewda(Y, T, H, W)

% lyngby_nn_cddewda    - Classifier neural network, output, diag 2nd
%
%       function ddEW = lyngby_nn_cddewda(Y, T, H, W)
%       
%       Input:  Y      Neural network output
%               T      Target output
%               H      Hidden layer output
%               W      Output weights
%
%       Output: ddEW   Derivative, a vector
%
%       Diagonal approximation to the second order derivative of the
%       error function for the classifier neural network with respect
%       to the output weights.
%
%       See also: lyngby_nn_cdew, lyngby_cddewds

% cvs : $Id: lyngby_nn_cddewda.m,v 1.1 1998/03/20 18:12:02 fnielsen Exp $
%       $Revision: 1.1 $

    [Np, Nh] = size(H);
    [Nhh, No] = size(W);
    if Nhh > Nh
      H = [ H ones(Np,1) ];
    end
    
    ddEW = (H.*H)' * (- Y(:,1:No).^2 + 2*Y(:,1:No) - T(:,1:No) ) / Np;

    % Numerical errors? 
    indices = find(W==0);
    if indices
      ddEW(indices) = zeros(1,length(indices));
    end




