function [out1, out2] = lyngby_nn_cddru(V, W, Reg);

% lyngby_nn_cddru      - 2nd order der. of regularization for weights
%
%	function ddRUv = lyngby_nn_cddru(V, W, Reg);
%	function [ddRV, ddRW] = lyngby_nn_cddru(V, W, Reg);
%
%	Input:	V      Input weights
%               W      Output weights
%               Reg    Regularization 
%
%	Output: ddRUv   Derivative, vector
%               ddRV    Derivative of input weights, matrix
%               ddRW    Derivative of output weights, matrix

% cvs : $Id: lyngby_nn_cddru.m,v 1.1 1998/03/20 14:30:16 fnielsen Exp $
%       $Revision: 1.1 $


    if nargout == 1
      out1 = Reg;
    else
      [Nii, Nh] = size(V);
      [Nhh, No] = size(W);
      Nv = Nii * Nh;
      Nw = Nhh * No;

      out1  = reshape(Reg(1:Nv), Nii, Nh);
      out2  = reshape(Reg(Nv+(1:Nw)), Nhh, No);
    end
