function [dEV, H12] = lyngby_nn_cdev(EY, H, X, V, W)

% lyngby_nn_cdev       - Classifier neural network, input 1st der.
%
%	function [dEV, H12] = lyngby_nn_cdev(EY, H, X, W)
%
%       Input:  EY   Error on output
%               H    Hidden layer output
%               X    Neural network input
%               W    Output weights
%
%       Output: dEV  Derivative in a matrix
%               H12  Intermidiate result: 1-H.^2
%
%       First order derivative for input weights in the classifier
%       neural network.
%
%       See also: lyngby_nn_cdew

% cvs : $Id: lyngby_nn_cdev.m,v 1.1 1998/03/20 14:30:16 fnielsen Exp $
%       $Revision: 1.1 $

    [Np, Noo] = size(EY);
    [Nii, Nh] = size(V);
    [Nhh, No] = size(W);
    
    H12 = 1 - H.*H;
    EH = EY(:,1:No) * W(1:Nh,:)';
    Eh = EH .* H12;
    dEV = 1/Np * X' * Eh;
    
    % Numerical errors? 
    indices = find(V==0);
    if indices
      dEV(indices) = zeros(1,length(indices));
    end
    

