function dEW = lyngby_nn_cdew(EY, HH, W)

% lyngby_nn_cdew       - Classifier neural network, output 1st der.
%
%       function dEW = lyngby_nn_cdew(EY, HH, W)
%
%       Input:  EY    Difference between neural network output and
%                     target output (Y-T)
%               HH    Hidden layer values with bias unit
%               W     Output weights
%
%       Output: dEW   Derivative in a matrix
%
%       First order derivative for the output weight of the classifier
%       neural network.
%
%       See also: lyngby_nn_cdev

% cvs : $Id: lyngby_nn_cdew.m,v 1.1 1998/03/20 14:30:17 fnielsen Exp $
%       $Revision: 1.1 $


    [Np, Noo] = size(EY);
    [Nhh, No] = size(W);
    
    dEW = HH' * EY(:,1:No) / Np;

    % Numerical errors? 
    indices = find(W==0);
    if indices
      dEW(indices) = zeros(1,length(indices));
    end











