function dRUv = lyngby_nn_cdru(V, W, Reg)

% lyngby_nn_cdru       - Neural network, regularization, 1st der.
%
%       function dRUv = lyngby_nn_cdru(V, W, Reg)
%
%       Input:  V     Input weights
%               W     Output weights
%               Reg   Regularization
%
%       Output: dRUv   Derivative in a vectorized matrix
%
%       First order derivative of the weight decay regularization
%       wrt. the weights for the classifier neural network. 
%
%       See also: lyngby_nn_cddru

% cvs : $Id: lyngby_nn_cdru.m,v 1.1 1998/03/20 14:30:17 fnielsen Exp $
%       $Revision: 1.1 $

      
    dRUv = Reg .* [V(:) ; W(:)];











