function E =  lyngby_nn_cerror(T, Y, O)

% lyngby_nn_cerror     - Classifier neural network error
%
%       function E =  lyngby_nn_cerror(T, Y, O)
%
%       Input:	T   Target Output
%		Y   Neural network softmax output
%               O   Neural network second layer output
%
%       Output:	E   Error
%
%       See also: lyngby_nn_ctrain, lyngby_nn_cmain

% cvs : $Id: lyngby_nn_cerror.m,v 1.3 2000/10/23 14:51:48 fnielsen Exp $
%       $Revision: 1.3 $


    [Np, Noo] = size(Y);
    [Np, No] = size(O);
    
    E = 1/Np * sum( log(1 + sum(exp(O)')) - sum((T(:,1:No) .* O)'))';

    if isinf(E)
      % There is a problem if exp(0) is large!!!
      E = 1/Np * sum(  max(O') - sum((T(:,1:No) .* O)'))';
    end









