function [Y, O, H] = lyngby_nn_cforward(X, V, W);

% lyngby_nn_cforward   - Classifier neural network forward 
%
%       function [Y, O, H] = lyngby_nn_cforward(X, V, W);
%
%       Input:  X   Input to neural network
%               V   Input weights
%               W   Output weights
%
%       Output: Y   Output from the neural network after the softmax
%                   is applied 
%               O   Output from the neural network before the softmax
%                   is applied
%               H   Hidden layer output
%
%       Implements:
%           Y = softmax( tanh(XV)W )
%
%       See also: lyngby_nn_cmain, lyngby_nn_ctrain

% cvs : $Id: lyngby_nn_cforward.m,v 1.2 1998/04/08 09:01:07 fnielsen Exp $
%       $Revision: 1.2 $

    [Np,  Ni] = size(X);
    [Nhh, No] = size(W);
    [Nii, Nh] = size(V);
    
    if Nii > Ni
      % Put threshold units on the input
      H = lyngby_nn_tanh( [X ones(Np,1)] * V);
    else
      H = lyngby_nn_tanh(X*V);
    end
    
    if Nhh > Nh
      % Put threshold unit a the hidden layer
      O = [H ones(Np,1)] * W;
    else
      O = H * W;
    end

    Y = lyngby_nn_csoftmax(O);






