function C =  lyngby_nn_cost(E, V, W, Reg)

% lyngby_nn_cost       - Cost function = error + regularization
%
%	function C =  lyngby_nn_cost(E, V, W, Reg)
%
%       Input:  E      Error
%               V      Input weights
%               W      Output weights
%               Reg    Regularization 
%
%       Output: C      Cost function
%
%       The costfunction for the neural network is defined as:
%
%           C = E + 1/2 * V * diag(Reg) * V
%
%       See also LYNGBY, LYNGBY_NN_EMAIN, LYNGBY_NN_QMAIN.
%
% $Id: lyngby_nn_cost.m,v 1.3 2004/06/03 17:38:32 fnielsen Exp $


    sizeReg = length(Reg);
    sizeU = prod(size(V)) + prod(size(W));
    
    if sizeReg == sizeU
      indexV = find(V);
      indexW = find(W);
      if isempty(indexV) | isempty(indexW)
	Uv = [ V(:) ; W(:) ];
	C = E + 0.5 * Uv'*(Reg.*Uv);
      else
	Urv = [ V(indexV) ; W(indexW) ];
	Regr = Reg([indexV ; indexW+prod(size(V))]);
	C = E + 0.5 * Urv'*(Regr.*Urv);
      end
    elseif sizeReg == 1 
      C = E + 0.5 * Reg * sum(sum(V.*V)) + 0.5 * Reg * sum(sum(W.*W));
    elseif sizeReg == 2
      C = E + ...
	  0.5 * Reg(1) * sum(sum(V.*V)) + ...
	  0.5 * Reg(2) * sum(sum(W.*W));
    elseif isempty(Reg)
      C = E;
    else
      error('Size og Regularization do not fit with weights');
    end

    



