function [VMask,WMask] = lyngby_nn_cpruneobd(X, T, V, W, Reg, arg1, ...
    arg2)

% lyngby_nn_cpruneobd  - Classifier neural network, OBD pruning
%
%	function [VMask,WMask] = lyngby_nn_cpruneobd(X, T, V, W, Reg,
%           'PropertyName', 'PropertyValue')
%
%	Input:	X      The datamatrix
%               T      Target
%               V      Input weights
%               W      Output weights
%               Reg    Regularization
%               Property:
%                  'DeleteFraction'   {0.05} Fraction to delete 
%                                     of remaining weights
%
%	Output:	VMask   Mask for input weights. Deleted weight is
%                       zero, else one
%               WMask   Mask for output weights.
%
%       Optimal brain Damage (OBD) pruning for the classifier neural
%       network.
%
%       See also: lyngby_nn_pruneobd

% cvs : $Id: lyngby_nn_cpruneobd.m,v 1.3 1998/04/08 13:58:56 fnielsen Exp $
%       $Revision: 1.3 $

    % Default
    deleteFraction = 0.05;

    % Parse Properties
    n = 1;
    while n <= nargin-6
      eval(sprintf('arg = lower(arg%d);', n));

      if strcmp(arg, 'deletefraction')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isreal(arg)
	  if arg > 0 & arg < 1
	    deleteFraction = arg;
	  else
	    error(sprintf('Wrong arg to ''DeleteFraction'': %s', arg))
	  end
	else
	  error('The argument with ''DeleteFraction'' should be a string.'); 
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    [Nii, Nh] = size(V);
    [Nhh, No] = size(W);
    
    [Y, O, H] = lyngby_nn_cforward(X, V, W);
    H12 = 1 - H.^2;
    [ddRV, ddRW] = lyngby_nn_cddru(V, W, Reg);
    ddEV = reshape(lyngby_nn_cddevds(X, Y, V, W, H12), Nii,Nh);
    ddEW = reshape(lyngby_nn_cddewds(Y, H, W), Nhh, No);
    
    ddCV = ddEV + ddRV;
    ddCW = ddEW + ddRW;

    [VMask, WMask] = lyngby_nn_pruneobd(V, W, ddCV, ddCW, ...
	'DeleteFraction', deleteFraction);
