function [CNew, VNew,WNew, succes, DV, DW] = lyngby_nn_csoftline(X, T, VOld, ...
    WOld, Reg, DV, DW, COld, maxIter)

% lyngby_nn_csoftline  - Classifier neural network soft linesearch
%
%	function [CNew, WNew,VNew, succes, DV, DW] =
%	    lyngby_nn_csoftline( ...
%           X, T, VOld, WOld, Reg, DV, DW, COld, maxIter)
%
%       Input:  X         Input
%               T         Target output
%               VOld      Old input weights
%               WOld      Old output weights
%               Reg       Regularization
%               DV        Step for input weights
%               DW        Step for output weights
%               COld      Old value of costfunction
%               maxIter   Maximal number of iterations
%
%       Output: CNew      New value for cost function
%               VNew      New input weights
%               WNew      New output weights
%               succes    0 if unsuccesfull otherwise returning the
%                         number of iterations
%               DV        Step taken for input weights
%               DW        Step taken for output weights
%
%       This function will make a soft linesearch until a decrease in
%       cost is found or the maximal number of iterations is reached.
%
%       See also: lyngby_nn_ctrain

% cvs : $Id: lyngby_nn_csoftline.m,v 1.1 1998/03/20 14:31:13 fnielsen Exp $
%       $Revision: 1.1 $

    for iter = 1:maxIter
      V = VOld + DV;
      W = WOld + DW;

      [Y,O,H] = lyngby_nn_cforward(X, V, W);
      E	      = lyngby_nn_cerror(T, Y, O);
      C	      = lyngby_nn_cost(E, V, W, Reg);
   
      if (C < COld)
	CNew = C;
	WNew = W;
	VNew = V;
	succes = iter;
	return;
      else 
	DV = DV / 2;
	DW = DW / 2;
      end
    end
    WNew   = W;
    VNew   = V;
    CNew   = C;
    succes = 0;



















