function Y = lyngby_nn_csoftmax(O);

% lyngby_nn_csoftmax   - Softmax for neural network classifier
%
%       function Y = lyngby_nn_csoftmax(O);
%
%       Input:  O   Input to the softmax layer
%
%       Output: Y   Softmax output
%
%       Implements a modified softmax function with "c-1" inputs and
%       "c" outputs.
%
%          Yi = exp(Oi) / (1 + sum(exp(Oi)) )
%
%          Yc = 1 - sum(Yi)
%
%       See also LYNGBY, LYNGBY_NN_CFORWARD, LYNGBY_INVLOGISTIC.
%
% $Id: lyngby_nn_csoftmax.m,v 1.2 2003/02/11 17:10:55 fnielsen Exp $


    [Np, No] = size(O);

    maxO = max(max(O));
    E = exp(O-maxO);

    Y = zeros(Np, No+1);
    Y(:,1:No) = E ./ (realmin+exp(-maxO) + sum(E')'*ones(1, No));
    Y(:,No+1) = 1 - sum(Y(:,1:No)')';

