function ddEW = lyngby_nn_eddewd(Y, H, W)

% lyngby_nn_eddewd     - Entropic neural network, output, diag 2nd
%
%       function ddEW = lyngby_nn_eddewd(Y, H, W)
%       
%       Input:  Y      Neural network output
%               H      Hidden layer output
%               W      Output weights
%
%       Output: ddEW   Derivative, a vector
%
%       Diagonal approximation to the second order derivative of the
%       error function for the entropic neural network with respect to
%       the output weights.
%
%       See also: lyngby_nn_edew

% cvs : $Id: lyngby_nn_eddewd.m,v 1.2 1998/03/19 13:53:23 fnielsen Exp $
%       $Revision: 1.2 $

    [Np, Nh] = size(H);
    [Nhh, No] = size(W);
    if Nhh > Nh
      H = [ H ones(Np,1) ];
    end
    
    ddEW = 1/(Np*No) * (H.*H)' * (1-Y.*Y);

    % Numerical errors? 
    indices = find(W==0);
    if indices
      ddEW(indices) = zeros(1,length(indices));
    end


