function [out1, out2] = lyngby_nn_eddru(V, W, Reg);

% lyngby_nn_eddru      - 2nd order der. of regularization for weights
%
%	function ddRUv = lyngby_nn_eddru(V, W, Reg);
%	function [ddRV, ddRW] = lyngby_nn_eddru(V, W, Reg);
%
%	Input:	V      Input weights
%               W      Output weights
%               Reg    Regularization 
%
%	Output: ddRUv   Derivative, vector
%               ddRV    Derivative of input weights, matrix
%               ddRW    Derivative of output weights, matrix

% cvs : $Id: lyngby_nn_eddru.m,v 1.2 1997/09/11 13:06:06 fnielsen Exp $
%       $Revision: 1.2 $


    if nargout == 1
      out1 = Reg;
    else
      [Nii, Nh] = size(V);
      [Nhh, No] = size(W);
      Nv = Nii * Nh;
      Nw = Nhh * No;
      
      out1  = reshape(Reg(1:Nv), Nii, Nh);
      out2  = reshape(Reg(Nv+(1:Nw)), Nhh, No);
    end
