function [dEV, H12] = lyngby_nn_edev(EY, H, X, V, W)

% lyngby_nn_edev       - Entropic neural network, input 1st der.
%
%	function [dEV, H12] = lyngby_nn_edev(EY, H, X, W)
%
%       Input:  EY   Error on output
%               H    Hidden layer output
%               X    Neural network input
%               W    Output weights
%
%       Output: dEV  Derivative in a matrix
%               H12  Intermidiate result: 1-H.^2
%
%       First order derivative for input weights in the entropic
%       neural network.
%
%       See also: lyngby_nn_edew

% cvs : $Id: lyngby_nn_edev.m,v 1.3 1998/03/18 13:39:34 fnielsen Exp $
%       $Revision: 1.3 $

    [Np, No] = size(EY);
    [Nii, Nh] = size(V);
    
    
    H12 = 1 - H.*H;
    EH = EY * W';
    EH = EH(:,1:Nh);
    Eh = EH .* H12;
    dEV = 1/(Np*No) * X' * Eh;
    
    % Numerical errors? 
    indices = find(V==0);
    if indices
      dEV(indices) = zeros(1,length(indices));
    end
    

