function dEW = lyngby_nn_edew(EY, HH, W)

% lyngby_nn_edew       - Entropic neural network, output, 1st der.
%
%       function dEW = lyngby_nn_edew(EY, HH, W)
%
%       Input:  EY    Difference between neural network output and
%                     target output (Y-T)
%               HH    Hidden layer values with bias unit
%               W     Output weights
%
%       Output: dEW   Derivative in a matrix
%
%       First order derivative for error function of the entropic
%       neural network with respect to the output weights.
%
%       See also: lyngby_nn_edev

% cvs : $Id: lyngby_nn_edew.m,v 1.3 1998/03/23 09:50:09 fnielsen Exp $
%       $Revision: 1.3 $


    dEW = HH' * EY ./ prod(size(EY));

    % Numerical errors? 
    indices = find(W==0);
    if indices
      dEW(indices) = zeros(1,length(indices));
    end











