function E =  lyngby_nn_eehl(T, Y)

% lyngby_nn_eehl       - Neural network entropic error (Hodge-Lehmann)
%
%       function E =  lyngby_nn_eehl(T, Y)
%
%       Input:	T   Target Output
%		Y   Neural network output
%
%       Output:	E   Error, normalized over outputs and with the
%                   Hodge-Lehmann estimator taken over patterns.
%
%       This function expects the Target to be -1 or +1.
%       If T=1 and Y=-1 the result is not Inf but log(realmin).      
%
%       See also: lyngby_nn_eerror, lyngby_nn_eehl

% cvs : $Id: lyngby_nn_eehl.m,v 1.1 1997/09/29 11:49:41 fnielsen Exp $
%       $Revision: 1.1 $

    [Np,No] = size(Y);

    if No > 1 
      E = 0.5/No * lyngby_meanhl(sum(( ...
	  -(1+T) .* log( 0.5*(1+Y)+realmin)  ...
	  - (1-T) .* log( 0.5*(1-Y)+realmin)  )'));
    else
      E = 0.5 * lyngby_meanhl(( ...
	  -(1+T) .* log( 0.5*(1+Y)+realmin)  ...
	  - (1-T) .* log( 0.5*(1-Y)+realmin)  ));
    end
	
    










