function E =  lyngby_nn_eemedian(T, Y)

% lyngby_nn_eemedian   - Neural network entropic error (median)
%
%       function E =  lyngby_nn_eemedian(T, Y)
%
%       Input:	T   Target Output
%		Y   Neural network output
%
%       Output:	E   Error, normalized over outputs and with the median
%                   taken over patterns.
%
%       This function expects the Target to be -1 or +1.
%       If T=1 and Y=-1 the result is not Inf but log(realmin).      
%
%       See also: lyngby_nn_eerror

% cvs : $Id: lyngby_nn_eemedian.m,v 1.2 1997/09/26 15:03:20 fnielsen Exp $
%       $Revision: 1.2 $

    [Np,No] = size(Y);

    % This should be computed:
    % E = 0.5/(Np*No) * sum(sum( (1+T).*log((1+T)./(1+Y)) + (1-T).*log((1-T)./(1-Y)) ));

    % Assuming T is always -1 or +1:
    if No > 1 
      E = 0.5/prod(No) * median(sum(( ...
	  -(1+T) .* log( 0.5*(1+Y)+realmin)  ...
	  - (1-T) .* log( 0.5*(1-Y)+realmin)  )'));
    else
      E = 0.5/prod(No) * median(( ...
	  -(1+T) .* log( 0.5*(1+Y)+realmin)  ...
	  - (1-T) .* log( 0.5*(1-Y)+realmin)  ));
    end
	
    % T not necessarily -1 or +1,
    % Does this have any meaning?
    % E = 0.5 * sum(sum( ...
    %	(1+T) .* ( log(1+T+realmin) - log(1+Y+realmin) ) + ...
    % 	(1-T) .* ( log(1-T+realmin) - log(1-Y+realmin) ) ));
    
    










