function E =  lyngby_nn_eerror(T, Y)

% lyngby_nn_eerror     - Calculate (cross-)entropic error
%
%       function E =  lyngby_nn_eerror(T, Y)
%
%       Input:	T   Target Output
%		Y   Neural network output
%
%       Output:	E   Error, normalized over patterns and outputs
%
%       If T=1 and Y=-1 the result is not Inf but log(realmin).      
%
%       The entropy in this case is also called 'cross-entropy', 
%       'relative entropy' or the 'Kullback' measure.
%
%       See also LYNGBY, LYNGBY_NN_EMAIN, LYNGBY_NN_COST.
%
% $Id: lyngby_nn_eerror.m,v 1.2 2004/06/03 17:34:49 fnielsen Exp $


    % This should be computed:
    % E = 0.5/(Np*No) * sum(sum( (1+T).*log((1+T)./(1+Y)) + (1-T).*log((1-T)./(1-Y)) ));

    
    if all(T==-1 | T==1)
      % Assuming T is always -1 or +1:
      E = 0.5/prod(size(Y)) * sum(sum( ...
	  -(1+T) .* log( 0.5*(1+Y)+realmin)  ...
	  - (1-T) .* log( 0.5*(1-Y)+realmin)  ));
    else
      % T not necessarily -1 or +1,
      E = 0.5 * sum(sum( ...
	  (1+T) .* ( log(1+T+realmin) - log(1+Y+realmin) ) + ...
	  (1-T) .* ( log(1-T+realmin) - log(1-Y+realmin) ) ));
    end
    










