function [Y, H] = lyngby_nn_eforward(X, V, W);

% lyngby_nn_eforward   - Entropic neural network, feed-forward
%
%       function [Y, H] = lyngby_nn_eforward(X, V, W);
%
%       Input:  X   Input to neural network
%               V   Input weights
%               W   Output weights
%
%       Output: Y   Output from the neural network
%               H   Hidden layer output
%
%       Feed-forward for the entropic neural network, ie. the network
%       equation.
%
%       Implements:
%           Y = tanh(tanh(XV)W)

% cvs : $Id: lyngby_nn_eforward.m,v 1.3 1998/03/23 09:54:07 fnielsen Exp $
%       $Revision: 1.3 $

    [Np,  Ni] = size(X);
    [Nhh,  No] = size(W);
    [Nii, Nh] = size(V);
    
    if Nii > Ni
      % Put threshold units on the input
      H = lyngby_nn_tanh( [X ones(Np,1)] * V);
    else
      H = lyngby_nn_tanh(X*V);
    end
    
    if Nhh > Nh
      % Put threshold unit a the hidden layer
      Y = lyngby_nn_tanh( [H ones(Np,1)] * W);
    else
      Y = lyngby_nn_tanh(H * W);
    end


