function [VMask,WMask] = lyngby_nn_epruneobd(X, T, V, W, Reg, arg1, ...
    arg2)

% lyngby_nn_epruneobd  - Pruning by Optimal Brain Damage (entropic)
%
%	function [VMask,WMask] = lyngby_nn_epruneobd(X, T, V, W, Reg,
%           'PropertyName', 'PropertyValue')
%
%	Input:	X      The datamatrix
%               T      Target
%               V      Input weights
%               W      Output weights
%               Reg    Regularization
%               Property:
%                  'DeleteFraction'   {0.05} Fraction to delete 
%                                     of remaining weights
%
%	Output:	VMask   Mask for input weights. Deleted weight is
%                       zero, else one
%               WMask   Mask for output weights.

% cvs : $Id: lyngby_nn_epruneobd.m,v 1.2 1997/09/11 13:06:49 fnielsen Exp $
%       $Revision: 1.2 $

    % Default
    deleteFraction = 0.05;

    % Parse Properties
    n = 1;
    while n <= nargin-6
      eval(sprintf('arg = lower(arg%d);', n));

      if strcmp(arg, 'deletefraction')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isreal(arg)
	  if arg > 0 & arg < 1
	    deleteFraction = arg;
	  else
	    error(sprintf('Wrong arg to ''DeleteFraction'': %s', arg))
	  end
	else
	  error('The argument with ''DeleteFraction'' should be a string.'); 
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end

    [Nii, Nh] = size(V);
    [Nhh, No] = size(W);
    
    [Y, H] = lyngby_nn_eforward(X, V, W);
    H12 = 1 - H.^2;
    [ddRV, ddRW] = lyngby_nn_eddru(V, W, Reg);
    ddEV = reshape(lyngby_nn_eddevds(X, Y, V, W, H12), Nii,Nh);
    ddEW = reshape(lyngby_nn_eddewd(Y, H, W), Nhh, No);
    
    ddCV = ddEV + ddRV;
    ddCW = ddEW + ddRW;
    
    [VMask, WMask] = lyngby_nn_pruneobd(V, W, ddCV, ddCW, ...
	'DeleteFraction', deleteFraction);












