function Tout = lyngby_nn_etarget(Tin)

% lyngby_nn_etarget    - Normalize target for entropic neural network
%
%       function Tout = lyngby_nn_etarget(Tin)
%
%       Input:  Tin    Target to be normalized
%
%       Output: Tout   Normalized target (column vector)
%
%       The entropic costfunction used "required" that the target is
%       from a binorminal distribution, and that the two classes are
%       identified as +1 and -1.
%
%       This function will take a vector with two different numbers
%       and return it as a vector containing +1 and -1.
%
%       See also: lyngby_nn_emain, lyngby_nn_eerror

% cvs : $Id: lyngby_nn_etarget.m,v 1.1 1997/09/04 16:10:19 fnielsen Exp $
%       $Revision: 1.1 $


    firstIndices = find(Tin == Tin(1));
    secondIndices = find(Tin ~= Tin(1));

    Tout = ones(length(Tin),1);
    if Tin(1) > Tin(secondIndices(1))
      Tout(secondIndices) = -1;
    else
      Tout(firstIndices) = -1;
    end
      