function [V, W] = lyngby_nn_initvw(N, arg1, arg2, arg3, arg4)

% lyngby_nn_initvw     - Initialize weights in neural network
%
%       function [V, W] = lyngby_nn_initvw(N, ...
%          'PropertyName', 'PropertyValue')
%
%       Input:  N   Neural network structure
%
%       Output: V   Input weights
%               W   Output weights
%               Property:
%                  'Seed'  Seed for random generator
%                  'Input' Input to the neural network. Used to scale
%                          the weights 
%
%       The neural network structure is containing the units in each
%       layer. The first column contains the number of input units,
%       the second column the number of hidden units, and the third
%       column the number of output units. The first row contains the
%       number of units counting a threshold unit.  
%
%       N = [ [input+threshold hidden+threshold output] ; ...
%             [input hidden output] ];
%
%       For a two-layer feed-forward neural network with 2 inputs, 4
%       hidden units, 1 output and with threshold units the structure
%       should be defined as: 
%
%       N = [ [ 3 5 1 ] ; [ 2 4 1] ]  
%
%       See also: lyngby_nn_qmain, lyngby_nn_emain

% cvs : $Id: lyngby_nn_initvw.m,v 1.3 1998/09/02 08:46:16 fnielsen Exp $
%       $Revision: 1.3 $


    % Default values
    seed = sum(100*clock);
    X = [];

    % Parse properties
    n = 1;
    while n < nargin-1
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'seed')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if (~isstr(arg)) & (length(arg) == 1) | isempty(arg)
	  seed = arg;
	else	  
	  error([ 'Argument to ''Seed'' should be a scalar value.']);
	end
      elseif strcmp(arg, 'input')
	n = n + 1;
	eval(sprintf('arg = arg%d;', n));
	if (~isstr(arg)) & isreal(arg)
	  if (size(arg,2) == N(2,1)) | (size(arg,2) == N(1,1))
	    X = arg;
	  else
	    error([ 'Argument to ''Input'' should have the ', ...
		  same size as the one specified in N.']);
	  end
	else	  
	  error([ 'Argument to ''Input'' should be a matrix.']);
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end
    
    Nii = N(1,1);
    Nhh = N(1,2);
    Ni  = N(2,1);
    Nh  = N(2,2);
    No  = N(2,3);
    Nv  = Nii * Nh;
    Nw  = Nhh * No;

    if ~isempty(seed)
      randn('seed', seed);
    end
    
    V = randn([Nii,Nh]);
    W = randn([Nhh,No]);

    if ~isempty(X)
      X = [X ones(size(X,1), Nii-size(X,2))];
      V = V ./ (ones(Nii, 1) * (std(X*V)+realmin));
      W = W ./ (ones(Nhh, 1) * ...
	  (std([tanh(X*V) ones(size(X,1),Nhh-Nh) ] * W) + realmin));
    end





















