function lyngby_nn_plotnet(V, W, arg1, arg2, arg3, arg4, arg5, arg6, ...
    arg7, arg8);

% lyngby_nn_plotnet    - Neural network, plot the network weights
%
%       function plotnet(V,W, PropertyName, PropertyValue)
%
%       Input:  V   Input) weights
%               W   Output weights
%               Property:
%                  'Type'    [ {net} | matrix ] type of ploting
%
%       See also: lyngby_nn_qmain, lyngby_nn_emain

% cvs : $Id: lyngby_nn_plotnet.m,v 1.6 1998/09/08 12:00:25 fnielsen Exp $
%       $Revision: 1.6 $


    % Default values
    plottype = 1;
    
    
    % Parse properties
    n = 1;
    while n < nargin-2
      eval(sprintf('arg = lower(arg%d);', n)); 
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = deblank(lower(arg%d));', n));
	if isstr(arg)
	  if strcmp(arg, 'net')
	    plottype = 1;
  	  elseif strcmp(arg, 'matrix')
	    plottype = 2;
	  else
	    error(sprintf('Argument to ''type'' not recognized: %s', ...
		arg));
	  end
	else	  
	  error('''type'' PropertyName should be followed by a string');
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end
    

    % Find network size
    [Nii, Nh] = size(V);
    [Nhh, No] = size(W);
    Ni = Nii - 1;
    
    if plottype == 1
      
      clf
      set(gcf, 'color', [1 1 1]);
      
      linethickness = 5;
      linethickness = linethickness / max([ abs(V(:)) ; abs(W(:))]);
      
      maxunits = max([Nii,Nhh,No]);	
      
      % Coordinates
      XI = 30;
      XH = 70;
      Xo = 110;
      YI = zeros(Nii,1);
      YH = zeros(Nhh,1);
      Yo = zeros(No,1);	

      text(35, -10, 'Input weights');
      text(80, -10, 'Output weights');
      
      % Draw units
      for i = 1 : Nii
	YI(i) = 100 * (i-0.5)/Nii;
	lyngby_circle(XI, YI(i), 1);
      end
      for j = 1 : Nhh
	YH(j) = 100 * (j-0.5)/Nhh;
	lyngby_circle(XH, YH(j), 1);
      end
      for k = 1 : No
	Yo(k) = 100 * (k-0.5)/No;
	lyngby_circle(Xo, Yo(k), 1);
      end
      YI = flipud(YI);
      YH = flipud(YH);
      Yo = flipud(Yo);
      
      if Nhh>Nh
	text(65, YH(Nhh)-3, 'bias');
      end
      if Nii>Ni
	text(25, YI(Nii)-3, 'bias');
      end
      
      % Draw Weights
      for i = 1 : Nii
	for j = 1 : Nh
	  if V(i,j) > 0
	    line([XI XH],[YI(i) YH(j)], 'Color', [1 0 0], ...
		'LineStyle', '-', ...
		'LineWidth', linethickness*abs(V(i,j)));
	  elseif V(i,j) < 0
	    line([XI XH],[YI(i) YH(j)], 'Color', [0 0 1], ...
		'LineStyle', '--', ...
		'LineWidth', linethickness*abs(V(i,j)));
	  end			
	end
      end
      for h = 1 : Nhh
	for o = 1 : No
	  if W(h,o) > 0
	    line([XH Xo],[YH(h) Yo(o)], 'Color', [1 0 0], ...
		'LineStyle', '-', ...
		'LineWidth', linethickness*abs(W(h,o)));
	  elseif W(h,o) < 0
	    line([XH Xo],[YH(h) Yo(o)],'Color', [ 0 0 1], ...
		'LineStyle', '--', ...
		'LineWidth', linethickness*abs(W(h,o)));
	  end			
	end
      end

      hPos = line([0 0],[0 0], 'Color', [1 0 0], ...
	  'LineStyle', '-', ...
	  'LineWidth', 2, 'HandleVisibility', 'off');
      hNeg = line([0 0],[0 0], 'Color', [0 0 1], ...
	  'LineStyle', '--', ...
	  'LineWidth', 2, 'HandleVisibility', 'off');

      
      legend([hPos hNeg], 'Positive', 'Negative');
      axis off;		
      axis([28 112 -5 105]);

     
    elseif plottype == 2

      % Colormap ?
      h = hot(36);
      h = h(1:32,:);
      c = [flipud(fliplr(h)) ; h];
      
      maxV = max(abs(V(:)));
      maxW = max(abs(W(:)));
      subplot(1,2,1) 
        imagesc([V zeros(Nii, Nhh-Nh)]', [-maxV maxV] )
	axis([0.5 Nii+0.5 0.5 Nhh+0.5]),
	title('Input weights')
	xlabel('Input index')
	ylabel('Hidden index')
	colorbar
      subplot(1,2,2)
        imagesc(W, [-maxW maxW])
	title('Output weights')
	xlabel('Output index')
	ylabel('Hidden index')
	colorbar
      colormap(c)
      
    end
      






