function ddEV = lyngby_nn_qddevds(X, V, W, H12)

% lyngby_nn_qddevds    - 2nd der., quadratic, input, diag gauss.
%
%       function ddEV = lyngby_nn_qddevds(X, V, W, H12)
%
%	Input:  X      Neural network input
%               V      Input weights
%               W      Output weights
%               H12    (1-tanh(XV).^2) 
%
%       Output: ddEV   Derivative in a matrix
%
%       Diagonal Gauss-Newton (symmetric) approximation to the second
%       order derivative of the qaudratic error function with respect
%       to the input weights in the neural network.

% cvs : $Id: lyngby_nn_qddevds.m,v 1.2 1997/09/12 14:33:13 fnielsen Exp $
%       $Revision: 1.2 $


    [Np, Ni]  = size(X);
    [Nii, Nh] = size(V);
    [Nhh, No] = size(W);

    if No > 1
      W2   = 1/(Np*No) * sum((W(1:Nh,:).*W(1:Nh,:))');
    else
      W2   = 1/(Np*No) * (W(1:Nh,:).*W(1:Nh,:))';
    end
    H122 = H12 .* H12;
    X2   = X .* X;

    ddEV = (X2' * H122) .* (ones(Nii,1) * W2);







