function [dEV, H12] = lyngby_nn_qdev(X, H, V, W, EY)

% lyngby_nn_qdev       - Quadratic neural network, input, 1st der.
%
%       function [dEV, H12] = lyngby_nn_qdev(X, H, V, W, EY)
%
%	Input:	X     Neural network input
%               H     Hidden layer
%               V     Input weights
%		W     Output weights
%               EY    Error on output
%
%	Output	dEV   First Order Derivative
%		H12   1 - tanh2(V*I)
%
%       First order derivative for the error function of the quadratic
%       neural network with respect to the input weights.
%
%       See also: lyngby_nn_qdew

% cvs : $Id: lyngby_nn_qdev.m,v 1.3 1998/03/20 14:23:40 fnielsen Exp $
%       $Revision: 1.3 $

    [Nhh, No] = size(W);
    [Np, Nh] = size(H);
    [Nii, Nh] = size(V);
    
    H12 = (1-H(:,1:Nh).^2);
    EH  = EY * W(1:Nh,:)';
    Eh  = EH .* H12;
    dEV = - 1/(Np*No) * X' * Eh;

    % Numerical errors? 
    indices = find(V==0);
    if indices
      dEV(indices) = zeros(1,length(indices));
    end

