function dEW = lyngby_nn_qdew(H, W, EY)

% lyngby_nn_qdew       - First order derivative, quadratic, Output weights
%
%	function dEW = lyngby_nn_qdew(H, W, EY)
%
%	Input:  H     Hidden units 
%               W     Output weights
%               EY    Difference between computed and target output
%
%       Output: dEW   Derivative

% cvs : $Id: lyngby_nn_qdew.m,v 1.2 1997/08/22 16:52:40 fnielsen Exp $
%       $Revision: 1.2 $

    [Np, Nh] = size(H);
    [Nhh, No] = size(W);
    if Nhh > Nh
      H = [H ones(Np,1)];
    end

    dEW = - 1/(Np*No) * H' * EY;

    % Numerical errors? 
    indices = find(W==0);
    if indices
      dEW(indices) = zeros(1,length(indices));
    end










