function dRUv = lyngby_nn_qdru(V, W, Reg)

% lyngby_nn_qdru       - Quadratic neural network, 1st der. reg.
%
%       function dRUv = lyngby_nn_qdru(V, W, Reg)
%
%       Input:  V     Input weights
%               W     Output weights
%               Reg   Regularization
%
%       Output: dRUv   Derivative in a vectorized matrix
%
%       First order derivative of the regularization (weight decay)
%       term of the costfunction of the quadratic neural network with
%       respect to the weights.
%
%       See also: lyngby_nn_qddru

% cvs : $Id: lyngby_nn_qdru.m,v 1.2 1998/03/23 09:58:03 fnielsen Exp $
%       $Revision: 1.2 $

      
    dRUv = Reg .* [V(:) ; W(:)];











