function [E, EY] = lyngby_nn_qerror(T, Y)	
	
% lyngby_nn_qerror     - Quadratic error
%
%	function function [E, EY] = lyngby_nn_qerror(T, Y)	
%
%	Input:	T	Target output
%		Y	Neural network output
%
%	Output:	EY	Error matrix for output units (T-Y)
%		E	Qudratic error, normalized over patterns and outputs
%
%       The function computes this:
%           0.5/(Np*No) * sum(sum( (T-Y).^2 ))
%
%       See also: lyngby_nn_eerror

% cvs : $Id: lyngby_nn_qerror.m,v 1.3 1998/02/26 11:47:11 fnielsen Exp $
%       $Revision: 1.3 $

    EY = T-Y;
    E  = 0.5/prod(size(Y)) * sum(sum(EY.^2));
















