function [Y, H] = lyngby_nn_qforward(X, V, W);

% lyngby_nn_qforward   - Neural network forward with linear output function
%
%       function [Y, H] = lyngby_nn_qforward(X, V, W);
%
%       Input:  X   Input to neural network
%               V   Input weights
%               W   Output weights
%
%       Output: Y   Output from the neural network
%               H   Hidden layer output
%
%       Neural network function for feed-forward, ie., implements:
%                            Y = tanh(XV)W
%
%       The hidden layer output (H) output is returned without a
%       threshold unit and the values of H is after the tanh has been
%       applied.
%
%       See also: lyngby_nn_qmain, lyngby_nn_qcost

% cvs : $Id: lyngby_nn_qforward.m,v 1.4 1998/02/13 18:17:39 fnielsen Exp $
%       $Revision: 1.4 $

    [Np,  Ni] = size(X);
    [Nhh,  No] = size(W);
    [Nii, Nh] = size(V);
    
    if Nii > Ni
      % Put threshold units on the input
      H = lyngby_nn_tanh( [X ones(Np,1)] * V);
    else
      H = lyngby_nn_tanh(X*V);
    end
    
    if Nhh > Nh
      % Put threshold unit a the hidden layer
      Y = [H ones(Np,1)] * W;
    else
      Y = H * W;
    end


