function [CNew, VNew,WNew, succes, DV, DW] = lyngby_nn_qsoftline(X, T, VOld, ...
    WOld, Reg, DV, DW, COld, maxIter)

% lyngby_nn_esoftline  - Soft linesearch with the quadratic costfunction
%
%	function [CNew, WNew,VNew, succes, DV, DW] = lyngby_nn_qsoftline( ...
%                 X, T, VOld, WOld, Reg, DV, DW, COld, maxIter)
%
%       Input:  X         Input
%               T         Target output
%               VOld      Old input weights
%               WOld      Old output weights
%               Reg       Regularization
%               DV        Step for input weights
%               DW        Step for output weights
%               COld      Old value of costfunction
%               maxIter   Maximal number of iterations
%
%       Output: CNew      New value for cost function
%               VNew      New input weights
%               WNew      New output weights
%               succes    0 if unsuccesfull otherwise returning the
%                         number of iterations
%               DV        Step taken for input weights
%               DW        Step taken for output weights
%
%       This function will make a soft linesearch until a decrease in
%       cost is found or the maximal number of iterations is reached.

% cvs : $Id: lyngby_nn_qsoftline.m,v 1.2 1997/09/10 15:06:24 fnielsen Exp $
%       $Revision: 1.2 $

    for iter = 1:maxIter
      V = VOld + DV;
      W = WOld + DW;

      [Y,H] = lyngby_nn_qforward(X, V, W);
      E	    = lyngby_nn_qerror(T, Y);
      C	    = lyngby_nn_cost(E, V, W, Reg);
   
      if (C < COld)
	CNew = C;
	WNew = W;
	VNew = V;
	succes = iter;
	return;
      else 
	DV = DV / 2;
	DW = DW / 2;
      end
    end
    WNew   = W;
    VNew   = V;
    CNew   = C;
    succes = 0;



    