function Reg = lyngby_nn_reg2reg(Reg, N)

% lyngby_nn_reg2reg    - Standardize regularization
%
%       function Reg = lyngby_nn_reg2reg(Reg, N)
%
%       Input:  Reg   Regularization
%               N     Neural network structure
%
%       Output: Reg   Regularization with the standardized length
%
%       The input regularization can either be of length 1, 2 or Nu,
%       where Nu is the total number of weights. The returned length
%       of Reg will be the total length.
%
%       If the input regularization is of length 2, then the first
%       value will be used as the regularization for the input weights
%       and the second value will be used as the value for the output
%       weights
%
%       Regularization is not put on the bias weigths.
%
%       See also: lyngby_nn_emain, lyngby_nn_qmain, lyngby_initvw

% cvs : $Id: lyngby_nn_reg2reg.m,v 1.5 1998/02/13 18:13:41 fnielsen Exp $
%       $Revision: 1.5 $


    Nii = N(1,1);
    Nhh = N(1,2);
    Ni = N(2,1);
    Nh = N(2,2);
    No = N(2,3);
    Nv = Nii * Nh;
    Nw = Nhh * No;
    Nu = Nv + Nw;

    if prod(size(Reg)) == 1
      Reg = Reg * [ ... 
	    reshape([ones(Ni,Nh) ; zeros(Nii-Ni,Nh)], Nii*Nh,1) ; ...
            reshape([ones(Nh,No) ; zeros(Nhh-Nh,No)], Nhh*No,1) ];
    elseif prod(size(Reg)) == 2
      Reg = [ ... 
	    Reg(1) * reshape([ones(Ni,Nh) ; zeros(Nii-Ni,Nh)], ...
	    Nii*Nh,1) ; ...
	    Reg(2) * reshape([ones(Nh,No) ; zeros(Nhh-Nh,No)], ...
	    Nhh*No,1) ];
    elseif prod(size(Reg)) == Nu
      % Reg = Reg
    else
      error(sprintf(['Regularization parameter do not have a ', ...
	    'proper size.\n' ...
	    'Reg: %dx%d'], size(Reg))); 
    end
