function [TrainIndices, ValIndices] = lyngby_nn_setsplit(arg1, arg2, ...
    arg3, arg4, arg5, arg6)

% lyngby_nn_setsplit   - Split the data into training and validation set
%
%       function [TrainIndices, ValIndices] =
%           lyngby_nn_setsplit('PropertyName', 'PropertyValue')
%
%       Input:  Property:
%                  'Type'           [ {Blocked} | Interlaced ]
%                  'Run'            Run definition
%                  'Paradigm'       Paradigm
%                  'TrainFraction'  { 0.5 } The part of the total set
%                                   that should be the training set  
%
%       Output: TrainIndices   Index for the training set
%               ValIndices     Index for the validation set
%
%       This function will split the data into a training set and a
%       validation set. If 'Type' is set to 'Blocked' and if the 'Run'
%       information is provided it will use this to split the data:
%       The scans in a single run will not be split in two groups. 
%       If 'Type' is set to 'Interlaced' every 1/TrainFraction'th is
%       put in the training set and the rest in the validation set
%
%       The default is that the first scans (until 'TrainFraction') is
%       returned as the training set and the reminder is returned as
%       the validation set.
%
%       See also: lyngby_runinfo

% cvs : $Id: lyngby_nn_setsplit.m,v 1.3 1998/09/10 08:42:03 fnielsen Exp $
%       $Revision: 1.3 $

    % Default values
    type = 1;
    trainFraction = 0.5;
    Paradigm = [];
    Run = [];

   
    % Parse Properties
    n = 1;
    while n <= nargin
      eval(sprintf('arg = lower(arg%d);', n));
      if strcmp(arg, 'type')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if strcmp(arg, 'blocked')
	  type = 1;
	elseif strcmp(arg, 'interlaced')
	  type = 2;
	else
	  error('The argument with ''type'' not recognized.'); 
	end
      elseif strcmp(arg, 'run')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isreal(arg)
	  Run = arg;
	else
	  error('The argument with ''run'' should be a vector.'); 
	end
      elseif strcmp(arg, 'paradigm')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isreal(arg)
	  Paradigm = arg;
	else
	  error('The argument with ''run'' should be a vector.'); 
	end

      elseif strcmp(arg, 'trainfraction')
	n = n + 1;
	eval(sprintf('arg = lower(arg%d);', n));
	if isreal(arg)
	  if prod(size(arg))
	    if arg >= 0 & arg <=1
	      trainFraction = arg;
	    else 
	      error(['Argument to ''TrainFraction'' should be ' ...
		    'between 0 and 1']);		
	    end
	  else
	    error(['Wrong argument to ''TrainFraction''. Should be ' ...
	      'a single number.']);
	  end
	else
	  error('The argument with ''TrainFraction'' should be a number.'); 
	end
      else
	error(sprintf('Invalid property: %s', arg));
      end
      n = n + 1;
    end


    TrainIndices = [];
    ValIndices = [];
    if type == 1
      % Blocked
      
      if isempty(Run)
	if isempty(Paradigm)
	  % Ups, now we are in deep troubles: no information what soever.
	  error(sprintf(['There is not enough information to split ' ...
		'the data.\n' ...
		'Provide information either about the Run or the '...
		'Paradigm']));
	else
	  % This function ought to do some intelligent here !!!
	  samples = length(Paradigm);
	  trainSamples = round(trainFraction * samples);
	  TrainIndices = 1:trainSamples;
	  ValIndices = (trainSamples+1):samples;
	end
      else
	[Runs, ScansPerRun] = lyngby_runinfo(Run);
	if Runs > 1
	  trainRuns = round(trainFraction * Runs);
	  Rcut = Run;
	  r = 1;
	  while r <= trainRuns
	    run = Rcut(1);
	    Rcut = Rcut(find(Rcut~=run));
	    TrainIndices = [TrainIndices ; find(Run==run)];
	    r = r + 1;
	  end
	  while r <= Runs
	    run = Rcut(1);
	    Rcut = Rcut(find(Rcut~=run));
	    ValIndices = [ValIndices ; find(Run==run)];
	    r = r + 1;
	  end
	  
	else
	  samples = length(Run);
	  trainSamples = round(trainFraction * samples);
	  TrainIndices = 1:trainSamples;
	  ValIndices = (trainSamples+1):samples;
	end
      end
    
    elseif type == 2
      % Interlaced

      if isempty(Run) & isempty(Paradigm)
	% Ups, now we are in deep troubles: no information what soever.
	error(sprintf(['There is not enough information to split ' ...
	      'the data.\n' ...
	      'Provide information either about the Run or the '...
	      'Paradigm']));
      end
      
      nScans = max([length(Run) length(Paradigm)]);
      if isempty(nScans)
	error('''Paradigm'' or ''Run'' should be provided')
      else
	TrainIndices = lyngby_set_unique( ...
	    round(1:(1/trainFraction):nScans));
	ValIndices = lyngby_set_diff(1:nScans, TrainIndices);
      end
    else
      error('Internal error')
    end














