function t = lyngby_nn_tanh(x)

% lyngby_nn_tanh       - Faster hyperbolic tangent
% 
%       function t = lyngby_nn_tanh(x)
%
%       This function seems to be more than 4 times faster than the
%       Matlab tanh function
%
%       The hint to this functions came from Peter Magnus
%       Noerregaard's nnsysid neural network matlab toolbox

% cvs : $Id: lyngby_nn_tanh.m,v 1.2 1998/03/18 13:51:10 fnielsen Exp $
%       $Revision: 1.2 $

    t = 1-2./(exp(2*x)+1);
