function [V, W] = lyngby_nn_u2vw(U, N)

% lyngby_nn_u2vw       - Vectorize neural network weights
%
%       function [V, W] = lyngby_nn_u2vw(U, N)
%
%       Input:  U   Vectorized weights (V first, then W)
%               N   Network structure
%
%       Output: V   Input weights
%               W   Output weights
%
%       Neural network structure 'N' is:
%
%           N = [ [Nii Nhh - ] ; [Ni Nh No] ];
%
%       Where Ni is input neurons, Nh hidden neurons, No output
%       neurons. Nii and Nhh are the corresponding counting the 'bias'
%       unit along.
%
%       See also: lyngby_nn_vw2u, lyngby_nn_qmain, lyngby_nn_emain,
%                 lyngby_nn_initvw

% cvs : $Id: lyngby_nn_u2vw.m,v 1.5 1999/06/11 13:04:16 fnielsen Exp $
%       $Revision: 1.5 $

    Nii = N(1,1);
    Nhh = N(1,2);
    Ni  = N(2,1);
    Nh  = N(2,2);
    No  = N(2,3);
    Nv  = Nii * Nh;
    Nw  = Nhh * No;
    
    V = reshape(U(1:Nv), Nii, Nh);
    W = reshape(U(Nv+(1:Nw)), Nhh, No); 







